package com.playcloud.msgsdkdemo;


import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;

import com.cloudplay.messagesdk.MessageHandler;
import com.cloudplay.messagesdk.MessageSDK;
import com.cloudplay.messagesdk.SendListener;
import com.cloudplay.messagesdk.entity.MessageInfo;

public class MainActivity extends Activity {
    private static final String TAG = "MainActivity";
    private String mPackageName;
    private String mAccessKeyId = "9599e53c";
    private Thread mThread;
    private boolean isRunning;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        mPackageName = getPackageName();
    }

    public MessageSDK getMessageInstance() {
        return MessageSDK.getInstance(mPackageName, mAccessKeyId);
    }

    public void initialize(View view) {
        MessageSDK messageSdk = MessageSDK.init(mPackageName, mAccessKeyId);//mAccessKeyId:0ce9fabd44f7c819001f17f1b788f6bd
        MessageHandler messageHandler = new MessageHandler() {
            @Override
            public void onReceiveMessage(MessageInfo messageInfo) {
                Log.w(TAG, messageInfo.getMid() + ";" + messageInfo.getPayload());
            }
        };
        Log.d(TAG, "isRunningCloud = " + messageSdk.isRunningCloud());
        messageSdk.setMessageHandler(messageHandler);
        messageSdk.setDebug(true);
    }

    public void socketDisConnect(View view) {
        MessageSDK.getInstance(mPackageName, mAccessKeyId).disConnect();
    }

    public void sendMessageTest(View view) {
        MessageSDK.getInstance(mPackageName, mAccessKeyId).sendMessage("messageContent:A", new SendListener() {
            @Override
            public void sendResult(boolean success, String messageId) {
                Log.w(TAG, messageId + success);
            }
        });
        Log.e(TAG, "pay str: " + getMessageInstance().getPayStr());
        Log.e(TAG, "config info: " + getMessageInstance().getConfigInfo());
    }

    public void sendMessageTest2(View view) {
        MessageSDK.getInstance(mPackageName, mAccessKeyId).sendMessage("messageContent:B", new SendListener() {
            @Override
            public void sendResult(boolean success, String messageId) {
                Log.w(TAG, messageId + success);
            }
        });
        Log.e(TAG, "pay str: " + getMessageInstance().getPayStr());
        Log.e(TAG, "config info: " + getMessageInstance().getConfigInfo());
    }

    public void sendMessageBatchTest(View view) {
        isRunning = true;
        mThread = new Thread(new Runnable() {
            public void run() {
                int num = 0;
                while (num < 100000 && isRunning) {
                    MessageSDK.getInstance(mPackageName, mAccessKeyId).sendMessage("messageContent:C", new SendListener() {
                        @Override
                        public void sendResult(boolean success, String mid) {
                            Log.w(TAG, mid + success);
                        }
                    });
                    try {
                        num = num + 1;
                        Thread.sleep(10);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        });
        mThread.start();
    }

    public void stopSendMessageBatchTest(View view) {
        isRunning = false;
    }
}
