/*
 * Decompiled with CFR 0.152.
 */
package com.cloudplay.messagesdk.socket;

import com.cloudplay.messagesdk.a.d;
import com.cloudplay.messagesdk.autobahn.WebSocket;
import com.cloudplay.messagesdk.autobahn.WebSocketConnection;
import com.cloudplay.messagesdk.autobahn.WebSocketConnectionHandler;
import com.cloudplay.messagesdk.autobahn.WebSocketException;
import com.cloudplay.messagesdk.autobahn.WebSocketOptions;
import com.cloudplay.messagesdk.socket.OnWebSocketListener;

public final class WebSocketClient {
    private static final String TAG = WebSocketClient.class.getName();
    private OnWebSocketListener mListener;
    private final WebSocket mConnection = new WebSocketConnection();

    public WebSocketClient(OnWebSocketListener onWebSocketListener) {
        this.mListener = onWebSocketListener;
    }

    public void connect(String string) {
        try {
            WebSocketOptions webSocketOptions = new WebSocketOptions();
            webSocketOptions.setReconnectInterval(250);
            this.mConnection.connect(string, new WebSocketConnectionHandler(){

                @Override
                public void onOpen() {
                    d.a(TAG, "onOpen");
                    if (WebSocketClient.this.mListener != null) {
                        WebSocketClient.this.mListener.onConnect();
                    }
                }

                @Override
                public void onTextMessage(String string) {
                    d.a(TAG, "onTextMessage:" + string);
                    if (WebSocketClient.this.mListener != null) {
                        WebSocketClient.this.mListener.onMessage(string);
                    }
                }

                @Override
                public void onClose(int n2, String string) {
                    d.a(TAG, "onClose code:" + n2 + ";onClose reason:" + string);
                    if (WebSocketClient.this.mListener != null) {
                        WebSocketClient.this.mListener.onDisConnect();
                    }
                }
            }, webSocketOptions);
        }
        catch (WebSocketException webSocketException) {
            d.b(TAG, webSocketException.toString());
        }
    }

    public void disconnect() {
        d.a(TAG, "web socket disconnect");
        if (this.mConnection.isConnected()) {
            this.mConnection.disconnect();
        }
    }

    public void sendMessage(String string) {
        if (this.mConnection.isConnected()) {
            this.mConnection.sendTextMessage(string);
        }
    }

    public void sendPing() {
        if (this.mConnection.isConnected()) {
            this.mConnection.sendPing();
        }
    }
}

