/*
 * Decompiled with CFR 0.152.
 */
package com.cloudplay.messagesdk.autobahn;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Base64;
import android.util.Log;
import com.cloudplay.messagesdk.autobahn.ByteBufferOutputStream;
import com.cloudplay.messagesdk.autobahn.WebSocketException;
import com.cloudplay.messagesdk.autobahn.WebSocketMessage;
import com.cloudplay.messagesdk.autobahn.WebSocketOptions;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Random;

public class WebSocketWriter
extends Handler {
    private static final boolean DEBUG = true;
    private static final String TAG = WebSocketWriter.class.getName();
    private final Random mRng = new Random();
    private final Handler mMaster;
    private final Looper mLooper;
    private final SocketChannel mSocket;
    private final WebSocketOptions mOptions;
    private final ByteBufferOutputStream mBuffer;

    public WebSocketWriter(Looper looper, Handler handler, SocketChannel socketChannel, WebSocketOptions webSocketOptions) {
        super(looper);
        this.mLooper = looper;
        this.mMaster = handler;
        this.mSocket = socketChannel;
        this.mOptions = webSocketOptions;
        this.mBuffer = new ByteBufferOutputStream(webSocketOptions.getMaxFramePayloadSize() + 14, 262144);
        Log.d((String)TAG, (String)"created");
    }

    public void forward(Object object) {
        Message message = this.obtainMessage();
        message.obj = object;
        this.sendMessage(message);
    }

    private void notify(Object object) {
        Message message = this.mMaster.obtainMessage();
        message.obj = object;
        this.mMaster.sendMessage(message);
    }

    private String newHandshakeKey() {
        byte[] byArray = new byte[16];
        this.mRng.nextBytes(byArray);
        return Base64.encodeToString((byte[])byArray, (int)2);
    }

    private byte[] newFrameMask() {
        byte[] byArray = new byte[4];
        this.mRng.nextBytes(byArray);
        return byArray;
    }

    private void sendClientHandshake(WebSocketMessage.ClientHandshake clientHandshake) {
        String string = clientHandshake.mQuery != null ? clientHandshake.mPath + "?" + clientHandshake.mQuery : clientHandshake.mPath;
        this.mBuffer.write("GET " + string + " HTTP/1.1");
        this.mBuffer.crlf();
        this.mBuffer.write("Host: " + clientHandshake.mHost);
        this.mBuffer.crlf();
        this.mBuffer.write("Upgrade: WebSocket");
        this.mBuffer.crlf();
        this.mBuffer.write("Connection: Upgrade");
        this.mBuffer.crlf();
        this.mBuffer.write("Sec-WebSocket-Key: " + this.newHandshakeKey());
        this.mBuffer.crlf();
        if (clientHandshake.mOrigin != null && !clientHandshake.mOrigin.equals("")) {
            this.mBuffer.write("Origin: " + clientHandshake.mOrigin);
            this.mBuffer.crlf();
        }
        if (clientHandshake.mSubprotocols != null && clientHandshake.mSubprotocols.length > 0) {
            this.mBuffer.write("Sec-WebSocket-Protocol: ");
            for (int i2 = 0; i2 < clientHandshake.mSubprotocols.length; ++i2) {
                this.mBuffer.write(clientHandshake.mSubprotocols[i2]);
                if (i2 == clientHandshake.mSubprotocols.length - 1) continue;
                this.mBuffer.write(", ");
            }
            this.mBuffer.crlf();
        }
        this.mBuffer.write("Sec-WebSocket-Version: 13");
        this.mBuffer.crlf();
        this.mBuffer.crlf();
    }

    private void sendClose(WebSocketMessage.Close close) {
        if (close.mCode > 0) {
            byte[] byArray = null;
            if (close.mReason != null && !close.mReason.equals("")) {
                byte[] byArray2 = close.mReason.getBytes("UTF-8");
                byArray = new byte[2 + byArray2.length];
                for (int i2 = 0; i2 < byArray2.length; ++i2) {
                    byArray[i2 + 2] = byArray2[i2];
                }
            } else {
                byArray = new byte[2];
            }
            if (byArray != null && byArray.length > 125) {
                throw new WebSocketException("close payload exceeds 125 octets");
            }
            byArray[0] = (byte)(close.mCode >> 8 & 0xFF);
            byArray[1] = (byte)(close.mCode & 0xFF);
            this.sendFrame(8, true, byArray);
        } else {
            this.sendFrame(8, true, null);
        }
    }

    private void sendPing(WebSocketMessage.Ping ping) {
        if (ping.mPayload != null && ping.mPayload.length > 125) {
            throw new WebSocketException("ping payload exceeds 125 octets");
        }
        this.sendFrame(9, true, ping.mPayload);
    }

    private void sendPong(WebSocketMessage.Pong pong) {
        if (pong.mPayload != null && pong.mPayload.length > 125) {
            throw new WebSocketException("pong payload exceeds 125 octets");
        }
        this.sendFrame(10, true, pong.mPayload);
    }

    private void sendBinaryMessage(WebSocketMessage.BinaryMessage binaryMessage) {
        if (binaryMessage.mPayload.length > this.mOptions.getMaxMessagePayloadSize()) {
            throw new WebSocketException("message payload exceeds payload limit");
        }
        this.sendFrame(2, true, binaryMessage.mPayload);
    }

    private void sendTextMessage(WebSocketMessage.TextMessage textMessage) {
        byte[] byArray = textMessage.mPayload.getBytes("UTF-8");
        if (byArray.length > this.mOptions.getMaxMessagePayloadSize()) {
            throw new WebSocketException("message payload exceeds payload limit");
        }
        this.sendFrame(1, true, byArray);
    }

    private void sendRawTextMessage(WebSocketMessage.RawTextMessage rawTextMessage) {
        if (rawTextMessage.mPayload.length > this.mOptions.getMaxMessagePayloadSize()) {
            throw new WebSocketException("message payload exceeds payload limit");
        }
        this.sendFrame(1, true, rawTextMessage.mPayload);
    }

    protected void sendFrame(int n2, boolean bl, byte[] byArray) {
        if (byArray != null) {
            this.sendFrame(n2, bl, byArray, 0, byArray.length);
        } else {
            this.sendFrame(n2, bl, null, 0, 0);
        }
    }

    protected void sendFrame(int n2, boolean bl, byte[] byArray, int n3, int n4) {
        long l2;
        int n5 = 0;
        if (bl) {
            n5 = (byte)(n5 | 0xFFFFFF80);
        }
        n5 = (byte)(n5 | (byte)n2);
        this.mBuffer.write(n5);
        int n6 = 0;
        if (this.mOptions.getMaskClientFrames()) {
            n6 = -128;
        }
        if ((l2 = (long)n4) <= 125L) {
            n6 = (byte)(n6 | (byte)l2);
            this.mBuffer.write(n6);
        } else if (l2 <= 65535L) {
            n6 = (byte)(n6 | 0x7E);
            this.mBuffer.write(n6);
            this.mBuffer.write(new byte[]{(byte)(l2 >> 8 & 0xFFL), (byte)(l2 & 0xFFL)});
        } else {
            n6 = (byte)(n6 | 0x7F);
            this.mBuffer.write(n6);
            this.mBuffer.write(new byte[]{(byte)(l2 >> 56 & 0xFFL), (byte)(l2 >> 48 & 0xFFL), (byte)(l2 >> 40 & 0xFFL), (byte)(l2 >> 32 & 0xFFL), (byte)(l2 >> 24 & 0xFFL), (byte)(l2 >> 16 & 0xFFL), (byte)(l2 >> 8 & 0xFFL), (byte)(l2 & 0xFFL)});
        }
        byte[] byArray2 = null;
        if (this.mOptions.getMaskClientFrames()) {
            byArray2 = this.newFrameMask();
            this.mBuffer.write(byArray2[0]);
            this.mBuffer.write(byArray2[1]);
            this.mBuffer.write(byArray2[2]);
            this.mBuffer.write(byArray2[3]);
        }
        if (l2 > 0L) {
            if (this.mOptions.getMaskClientFrames()) {
                int n7 = 0;
                while ((long)n7 < l2) {
                    int n8 = n7 + n3;
                    byArray[n8] = (byte)(byArray[n8] ^ byArray2[n7 % 4]);
                    ++n7;
                }
            }
            this.mBuffer.write(byArray, n3, n4);
        }
    }

    public void handleMessage(Message message) {
        try {
            this.mBuffer.clear();
            this.processMessage(message.obj);
            this.mBuffer.flip();
            while (this.mBuffer.remaining() > 0) {
                int n2 = this.mSocket.write(this.mBuffer.getBuffer());
            }
        }
        catch (SocketException socketException) {
            Log.d((String)TAG, (String)("run() : SocketException (" + socketException.toString() + ")"));
            this.notify(new WebSocketMessage.ConnectionLost());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.notify(new WebSocketMessage.Error(exception));
        }
    }

    protected void processMessage(Object object) {
        if (object instanceof WebSocketMessage.TextMessage) {
            this.sendTextMessage((WebSocketMessage.TextMessage)object);
        } else if (object instanceof WebSocketMessage.RawTextMessage) {
            this.sendRawTextMessage((WebSocketMessage.RawTextMessage)object);
        } else if (object instanceof WebSocketMessage.BinaryMessage) {
            this.sendBinaryMessage((WebSocketMessage.BinaryMessage)object);
        } else if (object instanceof WebSocketMessage.Ping) {
            this.sendPing((WebSocketMessage.Ping)object);
        } else if (object instanceof WebSocketMessage.Pong) {
            this.sendPong((WebSocketMessage.Pong)object);
        } else if (object instanceof WebSocketMessage.Close) {
            this.sendClose((WebSocketMessage.Close)object);
        } else if (object instanceof WebSocketMessage.ClientHandshake) {
            this.sendClientHandshake((WebSocketMessage.ClientHandshake)object);
        } else {
            if (object instanceof WebSocketMessage.Quit) {
                this.mLooper.quit();
                Log.d((String)TAG, (String)"ended");
                return;
            }
            this.processAppMessage(object);
        }
    }

    protected void processAppMessage(Object object) {
        throw new WebSocketException("unknown message received by WebSocketWriter");
    }
}

