/*
 * Decompiled with CFR 0.152.
 */
package com.cloudplay.messagesdk.autobahn;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.util.Pair;
import com.cloudplay.messagesdk.autobahn.NoCopyByteArrayOutputStream;
import com.cloudplay.messagesdk.autobahn.Utf8Validator;
import com.cloudplay.messagesdk.autobahn.WebSocketException;
import com.cloudplay.messagesdk.autobahn.WebSocketMessage;
import com.cloudplay.messagesdk.autobahn.WebSocketOptions;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;

public class WebSocketReader
extends Thread {
    private static final boolean DEBUG = true;
    private static final String TAG = WebSocketReader.class.getName();
    private final Handler mMaster;
    private final SocketChannel mSocket;
    private final WebSocketOptions mOptions;
    private final ByteBuffer mFrameBuffer;
    private NoCopyByteArrayOutputStream mMessagePayload;
    private static final int STATE_CLOSED = 0;
    private static final int STATE_CONNECTING = 1;
    private static final int STATE_CLOSING = 2;
    private static final int STATE_OPEN = 3;
    private boolean mStopped = false;
    private int mState;
    private boolean mInsideMessage = false;
    private int mMessageOpcode;
    private FrameHeader mFrameHeader;
    private Utf8Validator mUtf8Validator = new Utf8Validator();

    public WebSocketReader(Handler handler, SocketChannel socketChannel, WebSocketOptions webSocketOptions, String string) {
        super(string);
        this.mMaster = handler;
        this.mSocket = socketChannel;
        this.mOptions = webSocketOptions;
        this.mFrameBuffer = ByteBuffer.allocateDirect(webSocketOptions.getMaxFramePayloadSize() + 14);
        this.mMessagePayload = new NoCopyByteArrayOutputStream(webSocketOptions.getMaxMessagePayloadSize());
        this.mFrameHeader = null;
        this.mState = 1;
        Log.d((String)TAG, (String)"created");
    }

    public void quit() {
        this.mState = 0;
        Log.d((String)TAG, (String)"quit");
    }

    protected void notify(Object object) {
        Message message = this.mMaster.obtainMessage();
        message.obj = object;
        this.mMaster.sendMessage(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processData() {
        if (this.mFrameHeader == null) {
            if (this.mFrameBuffer.position() < 2) return false;
            byte by = this.mFrameBuffer.get(0);
            boolean bl = (by & 0x80) != 0;
            int n2 = (by & 0x70) >> 4;
            int n3 = by & 0xF;
            byte by2 = this.mFrameBuffer.get(1);
            boolean bl2 = (by2 & 0x80) != 0;
            int n4 = by2 & 0x7F;
            if (n2 != 0) {
                throw new WebSocketException("RSV != 0 and no extension negotiated");
            }
            if (bl2) {
                throw new WebSocketException("masked server frame");
            }
            if (n3 > 7) {
                if (!bl) {
                    throw new WebSocketException("fragmented control frame");
                }
                if (n4 > 125) {
                    throw new WebSocketException("control frame with payload length > 125 octets");
                }
                if (n3 != 8 && n3 != 9 && n3 != 10) {
                    throw new WebSocketException("control frame using reserved opcode " + n3);
                }
                if (n3 == 8 && n4 == 1) {
                    throw new WebSocketException("received close control frame with payload len 1");
                }
            } else {
                if (n3 != 0 && n3 != 1 && n3 != 2) {
                    throw new WebSocketException("data frame using reserved opcode " + n3);
                }
                if (!this.mInsideMessage && n3 == 0) {
                    throw new WebSocketException("received continuation data frame outside fragmented message");
                }
                if (this.mInsideMessage && n3 != 0) {
                    throw new WebSocketException("received non-continuation data frame while inside fragmented message");
                }
            }
            int n5 = bl2 ? 4 : 0;
            int n6 = 0;
            if (n4 < 126) {
                n6 = 2 + n5;
            } else if (n4 == 126) {
                n6 = 4 + n5;
            } else {
                if (n4 != 127) throw new Exception("logic error");
                n6 = 10 + n5;
            }
            if (this.mFrameBuffer.position() < n6) return false;
            int n7 = 2;
            long l2 = 0L;
            if (n4 == 126) {
                l2 = (0xFF & this.mFrameBuffer.get(n7)) << 8 | 0xFF & this.mFrameBuffer.get(n7 + 1);
                if (l2 < 126L) {
                    throw new WebSocketException("invalid data frame length (not using minimal length encoding)");
                }
                n7 += 2;
            } else if (n4 == 127) {
                if ((0x80 & this.mFrameBuffer.get(n7 + 0)) != 0) {
                    throw new WebSocketException("invalid data frame length (> 2^63)");
                }
                l2 = (long)(0xFF & this.mFrameBuffer.get(n7 + 0)) << 56 | (long)(0xFF & this.mFrameBuffer.get(n7 + 1)) << 48 | (long)(0xFF & this.mFrameBuffer.get(n7 + 2)) << 40 | (long)(0xFF & this.mFrameBuffer.get(n7 + 3)) << 32 | (long)(0xFF & this.mFrameBuffer.get(n7 + 4)) << 24 | (long)(0xFF & this.mFrameBuffer.get(n7 + 5)) << 16 | (long)(0xFF & this.mFrameBuffer.get(n7 + 6)) << 8 | (long)(0xFF & this.mFrameBuffer.get(n7 + 7));
                if (l2 < 65536L) {
                    throw new WebSocketException("invalid data frame length (not using minimal length encoding)");
                }
                n7 += 8;
            } else {
                l2 = n4;
            }
            if (l2 > (long)this.mOptions.getMaxFramePayloadSize()) {
                throw new WebSocketException("frame payload too large");
            }
            this.mFrameHeader = new FrameHeader();
            this.mFrameHeader.mOpcode = n3;
            this.mFrameHeader.mFin = bl;
            this.mFrameHeader.mReserved = n2;
            this.mFrameHeader.mPayloadLen = (int)l2;
            this.mFrameHeader.mHeaderLen = n6;
            this.mFrameHeader.mTotalLen = this.mFrameHeader.mHeaderLen + this.mFrameHeader.mPayloadLen;
            if (bl2) {
                this.mFrameHeader.mMask = new byte[4];
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.mFrameHeader.mMask[n7] = (byte)(0xFF & this.mFrameBuffer.get(n7 + i2));
                }
                n7 += 4;
            } else {
                this.mFrameHeader.mMask = null;
            }
            if (this.mFrameHeader.mPayloadLen == 0) return true;
            if (this.mFrameBuffer.position() < this.mFrameHeader.mTotalLen) return false;
            return true;
        }
        if (this.mFrameBuffer.position() < this.mFrameHeader.mTotalLen) return false;
        byte[] byArray = null;
        int n8 = this.mFrameBuffer.position();
        if (this.mFrameHeader.mPayloadLen > 0) {
            byArray = new byte[this.mFrameHeader.mPayloadLen];
            this.mFrameBuffer.position(this.mFrameHeader.mHeaderLen);
            this.mFrameBuffer.get(byArray, 0, this.mFrameHeader.mPayloadLen);
        }
        this.mFrameBuffer.position(this.mFrameHeader.mTotalLen);
        this.mFrameBuffer.limit(n8);
        this.mFrameBuffer.compact();
        if (this.mFrameHeader.mOpcode > 7) {
            if (this.mFrameHeader.mOpcode == 8) {
                int n9 = 1005;
                String string = null;
                if (this.mFrameHeader.mPayloadLen >= 2) {
                    n9 = (byArray[0] & 0xFF) * 256 + (byArray[1] & 0xFF);
                    if (n9 < 1000) throw new WebSocketException("invalid close code " + n9);
                    if (n9 >= 1000 && n9 <= 2999 && n9 != 1000 && n9 != 1001 && n9 != 1002 && n9 != 1003 && n9 != 1007 && n9 != 1008 && n9 != 1009 && n9 != 1010) {
                        if (n9 != 1011) throw new WebSocketException("invalid close code " + n9);
                    }
                    if (n9 >= 5000) {
                        throw new WebSocketException("invalid close code " + n9);
                    }
                    if (this.mFrameHeader.mPayloadLen > 2) {
                        byte[] byArray2 = new byte[this.mFrameHeader.mPayloadLen - 2];
                        System.arraycopy(byArray, 2, byArray2, 0, this.mFrameHeader.mPayloadLen - 2);
                        Utf8Validator utf8Validator = new Utf8Validator();
                        utf8Validator.validate(byArray2);
                        if (!utf8Validator.isValid()) {
                            throw new WebSocketException("invalid close reasons (not UTF-8)");
                        }
                        string = new String(byArray2, "UTF-8");
                    }
                }
                this.onClose(n9, string);
            } else if (this.mFrameHeader.mOpcode == 9) {
                this.onPing(byArray);
            } else {
                if (this.mFrameHeader.mOpcode != 10) throw new Exception("logic error");
                this.onPong(byArray);
            }
        } else {
            if (!this.mInsideMessage) {
                this.mInsideMessage = true;
                this.mMessageOpcode = this.mFrameHeader.mOpcode;
                if (this.mMessageOpcode == 1 && this.mOptions.getValidateIncomingUtf8()) {
                    this.mUtf8Validator.reset();
                }
            }
            if (byArray != null) {
                if (this.mMessagePayload.size() + byArray.length > this.mOptions.getMaxMessagePayloadSize()) {
                    throw new WebSocketException("message payload too large");
                }
                if (this.mMessageOpcode == 1 && this.mOptions.getValidateIncomingUtf8() && !this.mUtf8Validator.validate(byArray)) {
                    throw new WebSocketException("invalid UTF-8 in text message payload");
                }
                this.mMessagePayload.write(byArray);
            }
            if (this.mFrameHeader.mFin) {
                if (this.mMessageOpcode == 1) {
                    if (this.mOptions.getValidateIncomingUtf8() && !this.mUtf8Validator.isValid()) {
                        throw new WebSocketException("UTF-8 text message payload ended within Unicode code point");
                    }
                    if (this.mOptions.getReceiveTextMessagesRaw()) {
                        this.onRawTextMessage(this.mMessagePayload.toByteArray());
                    } else {
                        String string = new String(this.mMessagePayload.toByteArray(), "UTF-8");
                        this.onTextMessage(string);
                    }
                } else {
                    if (this.mMessageOpcode != 2) throw new Exception("logic error");
                    this.onBinaryMessage(this.mMessagePayload.toByteArray());
                }
                this.mInsideMessage = false;
                this.mMessagePayload.reset();
            }
        }
        this.mFrameHeader = null;
        if (this.mFrameBuffer.position() <= 0) return false;
        return true;
    }

    protected void onHandshake(boolean bl) {
        this.notify(new WebSocketMessage.ServerHandshake(bl));
    }

    protected void onClose(int n2, String string) {
        this.notify(new WebSocketMessage.Close(n2, string));
    }

    protected void onPing(byte[] byArray) {
        this.notify(new WebSocketMessage.Ping(byArray));
    }

    protected void onPong(byte[] byArray) {
        this.notify(new WebSocketMessage.Pong(byArray));
    }

    protected void onTextMessage(String string) {
        this.notify(new WebSocketMessage.TextMessage(string));
    }

    protected void onRawTextMessage(byte[] byArray) {
        this.notify(new WebSocketMessage.RawTextMessage(byArray));
    }

    protected void onBinaryMessage(byte[] byArray) {
        this.notify(new WebSocketMessage.BinaryMessage(byArray));
    }

    private boolean processHandshake() {
        boolean bl = false;
        for (int i2 = this.mFrameBuffer.position() - 4; i2 >= 0; --i2) {
            if (this.mFrameBuffer.get(i2 + 0) != 13 || this.mFrameBuffer.get(i2 + 1) != 10 || this.mFrameBuffer.get(i2 + 2) != 13 || this.mFrameBuffer.get(i2 + 3) != 10) continue;
            int n2 = this.mFrameBuffer.position();
            boolean bl2 = false;
            if (this.mFrameBuffer.get(0) == 72 && this.mFrameBuffer.get(1) == 84 && this.mFrameBuffer.get(2) == 84 && this.mFrameBuffer.get(3) == 80) {
                Pair<Integer, String> pair = this.parseHttpStatus();
                if ((Integer)pair.first >= 300) {
                    this.notify(new WebSocketMessage.ServerError((Integer)pair.first, (String)pair.second));
                    bl2 = true;
                }
            }
            this.mFrameBuffer.position(i2 + 4);
            this.mFrameBuffer.limit(n2);
            this.mFrameBuffer.compact();
            if (!bl2) {
                bl = this.mFrameBuffer.position() > 0;
                this.mState = 3;
            } else {
                bl = true;
                this.mState = 0;
                this.mStopped = true;
            }
            this.onHandshake(!bl2);
            break;
        }
        return bl;
    }

    private Map<String, String> parseHttpHeaders(byte[] byArray) {
        String[] stringArray;
        String string = new String(byArray, "UTF-8");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray = string.split("\r\n")) {
            String[] stringArray2;
            if (string2.length() <= 0 || (stringArray2 = string2.split(": ")).length != 2) continue;
            hashMap.put(stringArray2[0], stringArray2[1]);
            Log.w((String)TAG, (String)String.format("'%s'='%s'", stringArray2[0], stringArray2[1]));
        }
        return hashMap;
    }

    private Pair<Integer, String> parseHttpStatus() {
        int n2;
        int n3;
        int n4;
        for (n4 = 4; n4 < this.mFrameBuffer.position() && this.mFrameBuffer.get(n4) != 32; ++n4) {
        }
        for (n3 = n4 + 1; n3 < this.mFrameBuffer.position() && this.mFrameBuffer.get(n3) != 32; ++n3) {
        }
        ++n4;
        int n5 = 0;
        int n6 = 0;
        while (n4 + n6 < n3) {
            n2 = this.mFrameBuffer.get(n4 + n6) - 48;
            n5 *= 10;
            n5 += n2;
            ++n6;
        }
        for (n6 = ++n3; n6 < this.mFrameBuffer.position() && this.mFrameBuffer.get(n6) != 13; ++n6) {
        }
        n2 = n6 - n3;
        byte[] byArray = new byte[n2];
        this.mFrameBuffer.position(n3);
        this.mFrameBuffer.get(byArray, 0, n2);
        String string = new String(byArray, "UTF-8");
        Log.w((String)TAG, (String)String.format("Status: %d (%s)", n5, string));
        return new Pair((Object)n5, (Object)string);
    }

    private boolean consumeData() {
        if (this.mState == 3 || this.mState == 2) {
            return this.processData();
        }
        if (this.mState == 1) {
            return this.processHandshake();
        }
        if (this.mState == 0) {
            return false;
        }
        return false;
    }

    @Override
    public void run() {
        Log.d((String)TAG, (String)"running");
        try {
            this.mFrameBuffer.clear();
            do {
                int n2;
                if ((n2 = this.mSocket.read(this.mFrameBuffer)) > 0) {
                    while (this.consumeData()) {
                    }
                } else {
                    if (this.mState == 0) {
                        this.notify(new WebSocketMessage.Close(1000));
                        this.mStopped = true;
                        continue;
                    }
                    if (n2 >= 0) continue;
                    Log.d((String)TAG, (String)"run() : ConnectionLost");
                    this.notify(new WebSocketMessage.ConnectionLost());
                    this.mStopped = true;
                }
            } while (!this.mStopped);
        }
        catch (WebSocketException webSocketException) {
            Log.d((String)TAG, (String)("run() : WebSocketException (" + webSocketException.toString() + ")"));
            this.notify(new WebSocketMessage.ProtocolViolation(webSocketException));
        }
        catch (SocketException socketException) {
            Log.d((String)TAG, (String)("run() : SocketException (" + socketException.toString() + ")"));
            this.notify(new WebSocketMessage.ConnectionLost());
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)("run() : Exception (" + exception.toString() + ")"));
            this.notify(new WebSocketMessage.Error(exception));
        }
        finally {
            this.mStopped = true;
        }
        Log.d((String)TAG, (String)"ended");
    }

    private static class FrameHeader {
        public int mOpcode;
        public boolean mFin;
        public int mReserved;
        public int mHeaderLen;
        public int mPayloadLen;
        public int mTotalLen;
        public byte[] mMask;

        private FrameHeader() {
        }
    }
}

