/*
 * Decompiled with CFR 0.152.
 */
package com.cloudplay.messagesdk.autobahn;

public class WebSocketOptions {
    private int mMaxFramePayloadSize;
    private int mMaxMessagePayloadSize;
    private boolean mReceiveTextMessagesRaw;
    private boolean mTcpNoDelay;
    private int mSocketReceiveTimeout;
    private int mSocketConnectTimeout;
    private boolean mValidateIncomingUtf8;
    private boolean mMaskClientFrames;
    private int mReconnectInterval;

    public WebSocketOptions() {
        this.mMaxFramePayloadSize = 131072;
        this.mMaxMessagePayloadSize = 131072;
        this.mReceiveTextMessagesRaw = false;
        this.mTcpNoDelay = true;
        this.mSocketReceiveTimeout = 200;
        this.mSocketConnectTimeout = 6000;
        this.mValidateIncomingUtf8 = true;
        this.mMaskClientFrames = true;
        this.mReconnectInterval = 0;
    }

    public WebSocketOptions(WebSocketOptions webSocketOptions) {
        this.mMaxFramePayloadSize = webSocketOptions.mMaxFramePayloadSize;
        this.mMaxMessagePayloadSize = webSocketOptions.mMaxMessagePayloadSize;
        this.mReceiveTextMessagesRaw = webSocketOptions.mReceiveTextMessagesRaw;
        this.mTcpNoDelay = webSocketOptions.mTcpNoDelay;
        this.mSocketReceiveTimeout = webSocketOptions.mSocketReceiveTimeout;
        this.mSocketConnectTimeout = webSocketOptions.mSocketConnectTimeout;
        this.mValidateIncomingUtf8 = webSocketOptions.mValidateIncomingUtf8;
        this.mMaskClientFrames = webSocketOptions.mMaskClientFrames;
        this.mReconnectInterval = webSocketOptions.mReconnectInterval;
    }

    public void setReceiveTextMessagesRaw(boolean bl) {
        this.mReceiveTextMessagesRaw = bl;
    }

    public boolean getReceiveTextMessagesRaw() {
        return this.mReceiveTextMessagesRaw;
    }

    public void setMaxFramePayloadSize(int n2) {
        if (n2 > 0) {
            this.mMaxFramePayloadSize = n2;
            if (this.mMaxMessagePayloadSize < this.mMaxFramePayloadSize) {
                this.mMaxMessagePayloadSize = this.mMaxFramePayloadSize;
            }
        }
    }

    public int getMaxFramePayloadSize() {
        return this.mMaxFramePayloadSize;
    }

    public void setMaxMessagePayloadSize(int n2) {
        if (n2 > 0) {
            this.mMaxMessagePayloadSize = n2;
            if (this.mMaxMessagePayloadSize < this.mMaxFramePayloadSize) {
                this.mMaxFramePayloadSize = this.mMaxMessagePayloadSize;
            }
        }
    }

    public int getMaxMessagePayloadSize() {
        return this.mMaxMessagePayloadSize;
    }

    public void setTcpNoDelay(boolean bl) {
        this.mTcpNoDelay = bl;
    }

    public boolean getTcpNoDelay() {
        return this.mTcpNoDelay;
    }

    public void setSocketReceiveTimeout(int n2) {
        if (n2 >= 0) {
            this.mSocketReceiveTimeout = n2;
        }
    }

    public int getSocketReceiveTimeout() {
        return this.mSocketReceiveTimeout;
    }

    public void setSocketConnectTimeout(int n2) {
        if (n2 >= 0) {
            this.mSocketConnectTimeout = n2;
        }
    }

    public int getSocketConnectTimeout() {
        return this.mSocketConnectTimeout;
    }

    public void setValidateIncomingUtf8(boolean bl) {
        this.mValidateIncomingUtf8 = bl;
    }

    public boolean getValidateIncomingUtf8() {
        return this.mValidateIncomingUtf8;
    }

    public void setMaskClientFrames(boolean bl) {
        this.mMaskClientFrames = bl;
    }

    public boolean getMaskClientFrames() {
        return this.mMaskClientFrames;
    }

    public void setReconnectInterval(int n2) {
        this.mReconnectInterval = n2;
    }

    public int getReconnectInterval() {
        this.mReconnectInterval *= 2;
        if (this.mReconnectInterval > 64000) {
            this.mReconnectInterval = 0;
        }
        return this.mReconnectInterval;
    }
}

