/*
 * Decompiled with CFR 0.152.
 */
package com.cloudplay.messagesdk.autobahn;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.cloudplay.messagesdk.autobahn.WebSocket;
import com.cloudplay.messagesdk.autobahn.WebSocketException;
import com.cloudplay.messagesdk.autobahn.WebSocketMessage;
import com.cloudplay.messagesdk.autobahn.WebSocketOptions;
import com.cloudplay.messagesdk.autobahn.WebSocketReader;
import com.cloudplay.messagesdk.autobahn.WebSocketWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.SocketChannel;

public class WebSocketConnection
implements WebSocket {
    private static final boolean DEBUG = true;
    private static final String TAG = WebSocketConnection.class.getName();
    protected Handler mMasterHandler;
    protected WebSocketReader mReader;
    protected WebSocketWriter mWriter;
    protected HandlerThread mWriterThread;
    protected SocketChannel mTransportChannel;
    private URI mWsUri;
    private String mWsScheme;
    private String mWsHost;
    private int mWsPort;
    private String mWsPath;
    private String mWsQuery;
    private String[] mWsSubprotocols;
    private WebSocket.ConnectionHandler mWsHandler;
    protected WebSocketOptions mOptions;
    private boolean mActive;
    private boolean mPrevConnected;

    public WebSocketConnection() {
        Log.d((String)TAG, (String)"created");
        this.createHandler();
        this.mActive = false;
        this.mPrevConnected = false;
    }

    @Override
    public void sendPing() {
        this.mWriter.forward(new WebSocketMessage.Ping());
    }

    @Override
    public void sendTextMessage(String string) {
        this.mWriter.forward(new WebSocketMessage.TextMessage(string));
    }

    @Override
    public void sendRawTextMessage(byte[] byArray) {
        this.mWriter.forward(new WebSocketMessage.RawTextMessage(byArray));
    }

    @Override
    public void sendBinaryMessage(byte[] byArray) {
        this.mWriter.forward(new WebSocketMessage.BinaryMessage(byArray));
    }

    @Override
    public boolean isConnected() {
        return this.mTransportChannel != null && this.mTransportChannel.isConnected();
    }

    private void failConnection(int n2, String string) {
        Log.d((String)TAG, (String)("fail connection [code = " + n2 + ", reason = " + string));
        if (this.mReader != null) {
            this.mReader.quit();
            try {
                this.mReader.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            Log.d((String)TAG, (String)"mReader already NULL");
        }
        if (this.mWriter != null) {
            this.mWriter.forward(new WebSocketMessage.Quit());
            try {
                this.mWriterThread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            Log.d((String)TAG, (String)"mWriter already NULL");
        }
        if (this.mTransportChannel != null) {
            try {
                this.mTransportChannel.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            Log.d((String)TAG, (String)"mTransportChannel already NULL");
        }
        this.onClose(n2, string);
        Log.d((String)TAG, (String)"worker threads stopped");
    }

    @Override
    public void connect(String string, WebSocket.ConnectionHandler connectionHandler) {
        this.connect(string, null, connectionHandler, new WebSocketOptions());
    }

    @Override
    public void connect(String string, WebSocket.ConnectionHandler connectionHandler, WebSocketOptions webSocketOptions) {
        this.connect(string, null, connectionHandler, webSocketOptions);
    }

    public void connect(String string, String[] stringArray, WebSocket.ConnectionHandler connectionHandler, WebSocketOptions webSocketOptions) {
        if (this.mTransportChannel != null && this.mTransportChannel.isConnected()) {
            throw new WebSocketException("already connected");
        }
        try {
            this.mWsUri = new URI(string);
            if (!this.mWsUri.getScheme().equals("ws") && !this.mWsUri.getScheme().equals("wss")) {
                throw new WebSocketException("unsupported scheme for WebSockets URI");
            }
            if (this.mWsUri.getScheme().equals("wss")) {
                throw new WebSocketException("secure WebSockets not implemented");
            }
            this.mWsScheme = this.mWsUri.getScheme();
            this.mWsPort = this.mWsUri.getPort() == -1 ? (this.mWsScheme.equals("ws") ? 80 : 443) : this.mWsUri.getPort();
            if (this.mWsUri.getHost() == null) {
                throw new WebSocketException("no host specified in WebSockets URI");
            }
            this.mWsHost = this.mWsUri.getHost();
            this.mWsPath = this.mWsUri.getRawPath() == null || this.mWsUri.getRawPath().equals("") ? "/" : this.mWsUri.getRawPath();
            this.mWsQuery = this.mWsUri.getRawQuery() == null || this.mWsUri.getRawQuery().equals("") ? null : this.mWsUri.getRawQuery();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new WebSocketException("invalid WebSockets URI");
        }
        this.mWsSubprotocols = stringArray;
        this.mWsHandler = connectionHandler;
        this.mOptions = new WebSocketOptions(webSocketOptions);
        this.mActive = true;
        new WebSocketConnector().start();
    }

    @Override
    public void disconnect() {
        if (this.mWriter != null) {
            this.mWriter.forward(new WebSocketMessage.Close(1000));
        } else {
            Log.d((String)TAG, (String)"could not send Close .. writer already NULL");
        }
        if (this.mReader != null) {
            this.mReader.quit();
        } else {
            Log.d((String)TAG, (String)"could not send Close .. reader already NULL");
        }
        this.mActive = false;
        this.mPrevConnected = false;
    }

    public boolean reconnect() {
        if (!this.isConnected() && this.mWsUri != null) {
            new WebSocketConnector().start();
            return true;
        }
        return false;
    }

    protected boolean scheduleReconnect() {
        boolean bl;
        int n2 = this.mOptions.getReconnectInterval();
        boolean bl2 = bl = this.mActive && this.mPrevConnected && n2 > 0;
        if (bl) {
            Log.d((String)TAG, (String)"Reconnection scheduled");
            this.mMasterHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Log.d((String)TAG, (String)"Reconnecting...");
                    WebSocketConnection.this.reconnect();
                }
            }, (long)n2);
        }
        return bl;
    }

    private void onClose(int n2, String string) {
        block6: {
            boolean bl = false;
            if (n2 == 2 || n2 == 3) {
                bl = this.scheduleReconnect();
            }
            if (this.mWsHandler != null) {
                try {
                    if (bl) {
                        this.mWsHandler.onClose(7, string);
                        break block6;
                    }
                    this.mWsHandler.onClose(n2, string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                Log.d((String)TAG, (String)"mWsHandler already NULL");
            }
        }
    }

    protected void createHandler() {
        this.mMasterHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                if (message.obj instanceof WebSocketMessage.TextMessage) {
                    WebSocketMessage.TextMessage textMessage = (WebSocketMessage.TextMessage)message.obj;
                    if (WebSocketConnection.this.mWsHandler != null) {
                        WebSocketConnection.this.mWsHandler.onTextMessage(textMessage.mPayload);
                    } else {
                        Log.d((String)TAG, (String)"could not call onTextMessage() .. handler already NULL");
                    }
                } else if (message.obj instanceof WebSocketMessage.RawTextMessage) {
                    WebSocketMessage.RawTextMessage rawTextMessage = (WebSocketMessage.RawTextMessage)message.obj;
                    if (WebSocketConnection.this.mWsHandler != null) {
                        WebSocketConnection.this.mWsHandler.onRawTextMessage(rawTextMessage.mPayload);
                    } else {
                        Log.d((String)TAG, (String)"could not call onRawTextMessage() .. handler already NULL");
                    }
                } else if (message.obj instanceof WebSocketMessage.BinaryMessage) {
                    WebSocketMessage.BinaryMessage binaryMessage = (WebSocketMessage.BinaryMessage)message.obj;
                    if (WebSocketConnection.this.mWsHandler != null) {
                        WebSocketConnection.this.mWsHandler.onBinaryMessage(binaryMessage.mPayload);
                    } else {
                        Log.d((String)TAG, (String)"could not call onBinaryMessage() .. handler already NULL");
                    }
                } else if (message.obj instanceof WebSocketMessage.Ping) {
                    WebSocketMessage.Ping ping = (WebSocketMessage.Ping)message.obj;
                    Log.d((String)TAG, (String)"WebSockets Ping received");
                    WebSocketMessage.Pong pong = new WebSocketMessage.Pong();
                    pong.mPayload = ping.mPayload;
                    WebSocketConnection.this.mWriter.forward(pong);
                } else if (message.obj instanceof WebSocketMessage.Pong) {
                    WebSocketMessage.Pong pong = (WebSocketMessage.Pong)message.obj;
                    Log.d((String)TAG, (String)"WebSockets Pong received");
                } else if (message.obj instanceof WebSocketMessage.Close) {
                    int n2;
                    WebSocketMessage.Close close = (WebSocketMessage.Close)message.obj;
                    Log.d((String)TAG, (String)("WebSockets Close received (" + close.mCode + " - " + close.mReason + ")"));
                    int n3 = n2 = close.mCode == 1000 ? 1 : 3;
                    if (WebSocketConnection.this.mActive) {
                        WebSocketConnection.this.mWriter.forward(new WebSocketMessage.Close(1000));
                    } else {
                        try {
                            WebSocketConnection.this.mTransportChannel.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    WebSocketConnection.this.onClose(n2, close.mReason);
                } else if (message.obj instanceof WebSocketMessage.ServerHandshake) {
                    WebSocketMessage.ServerHandshake serverHandshake = (WebSocketMessage.ServerHandshake)message.obj;
                    Log.d((String)TAG, (String)"opening handshake received");
                    if (serverHandshake.mSuccess) {
                        if (WebSocketConnection.this.mWsHandler != null) {
                            WebSocketConnection.this.mWsHandler.onOpen();
                        } else {
                            Log.d((String)TAG, (String)"could not call onOpen() .. handler already NULL");
                        }
                    } else {
                        Log.d((String)TAG, (String)"serverHandshake failed");
                    }
                } else if (message.obj instanceof WebSocketMessage.ConnectionLost) {
                    WebSocketMessage.ConnectionLost connectionLost = (WebSocketMessage.ConnectionLost)message.obj;
                    WebSocketConnection.this.failConnection(3, "WebSockets connection lost");
                } else if (message.obj instanceof WebSocketMessage.ProtocolViolation) {
                    WebSocketMessage.ProtocolViolation protocolViolation = (WebSocketMessage.ProtocolViolation)message.obj;
                    WebSocketConnection.this.failConnection(4, "WebSockets protocol violation");
                } else if (message.obj instanceof WebSocketMessage.Error) {
                    WebSocketMessage.Error error = (WebSocketMessage.Error)message.obj;
                    WebSocketConnection.this.failConnection(5, "WebSockets internal error (" + error.mException.toString() + ")");
                } else if (message.obj instanceof WebSocketMessage.ServerError) {
                    WebSocketMessage.ServerError serverError = (WebSocketMessage.ServerError)message.obj;
                    WebSocketConnection.this.failConnection(6, "Server error " + serverError.mStatusCode + " (" + serverError.mStatusMessage + ")");
                } else {
                    WebSocketConnection.this.processAppMessage(message.obj);
                }
            }
        };
    }

    protected void processAppMessage(Object object) {
    }

    protected void createWriter() {
        this.mWriterThread = new HandlerThread("WebSocketWriter");
        this.mWriterThread.start();
        this.mWriter = new WebSocketWriter(this.mWriterThread.getLooper(), this.mMasterHandler, this.mTransportChannel, this.mOptions);
        Log.d((String)TAG, (String)"WS writer created and started");
    }

    protected void createReader() {
        this.mReader = new WebSocketReader(this.mMasterHandler, this.mTransportChannel, this.mOptions, "WebSocketReader");
        this.mReader.start();
        Log.d((String)TAG, (String)"WS reader created and started!");
    }

    private class WebSocketConnector
    extends Thread {
        private WebSocketConnector() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("WebSocketConnector");
            try {
                WebSocketConnection.this.mTransportChannel = SocketChannel.open();
                WebSocketConnection.this.mTransportChannel.socket().connect(new InetSocketAddress(WebSocketConnection.this.mWsHost, WebSocketConnection.this.mWsPort), WebSocketConnection.this.mOptions.getSocketConnectTimeout());
                WebSocketConnection.this.mTransportChannel.socket().setSoTimeout(WebSocketConnection.this.mOptions.getSocketReceiveTimeout());
                WebSocketConnection.this.mTransportChannel.socket().setTcpNoDelay(WebSocketConnection.this.mOptions.getTcpNoDelay());
            }
            catch (IOException iOException) {
                WebSocketConnection.this.onClose(2, iOException.getMessage());
                return;
            }
            if (WebSocketConnection.this.mTransportChannel.isConnected()) {
                try {
                    WebSocketConnection.this.createReader();
                    WebSocketConnection.this.createWriter();
                    WebSocketMessage.ClientHandshake clientHandshake = new WebSocketMessage.ClientHandshake(WebSocketConnection.this.mWsHost + ":" + WebSocketConnection.this.mWsPort);
                    clientHandshake.mPath = WebSocketConnection.this.mWsPath;
                    clientHandshake.mQuery = WebSocketConnection.this.mWsQuery;
                    clientHandshake.mSubprotocols = WebSocketConnection.this.mWsSubprotocols;
                    WebSocketConnection.this.mWriter.forward(clientHandshake);
                    WebSocketConnection.this.mPrevConnected = true;
                }
                catch (Exception exception) {
                    WebSocketConnection.this.onClose(5, exception.getMessage());
                    return;
                }
            } else {
                WebSocketConnection.this.onClose(2, "Could not connect to WebSocket server");
                return;
            }
        }
    }
}

