/*
 * Decompiled with CFR 0.152.
 */
package com.cloudplay.messagesdk.autobahn;

import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private final int mInitialSize;
    private final int mGrowSize;
    private ByteBuffer mBuffer;

    public ByteBufferOutputStream() {
        this(131072, 65536);
    }

    public ByteBufferOutputStream(int n2, int n3) {
        this.mInitialSize = n2;
        this.mGrowSize = n3;
        this.mBuffer = ByteBuffer.allocateDirect(this.mInitialSize);
        this.mBuffer.clear();
    }

    public ByteBuffer getBuffer() {
        return this.mBuffer;
    }

    public Buffer flip() {
        return this.mBuffer.flip();
    }

    public Buffer clear() {
        return this.mBuffer.clear();
    }

    public int remaining() {
        return this.mBuffer.remaining();
    }

    public synchronized void expand(int n2) {
        if (n2 > this.mBuffer.capacity()) {
            ByteBuffer byteBuffer = this.mBuffer;
            int n3 = this.mBuffer.position();
            int n4 = (n2 / this.mGrowSize + 1) * this.mGrowSize;
            this.mBuffer = ByteBuffer.allocateDirect(n4);
            byteBuffer.clear();
            this.mBuffer.clear();
            this.mBuffer.put(byteBuffer);
            this.mBuffer.position(n3);
        }
    }

    @Override
    public synchronized void write(int n2) {
        if (this.mBuffer.position() + 1 > this.mBuffer.capacity()) {
            this.expand(this.mBuffer.capacity() + 1);
        }
        this.mBuffer.put((byte)n2);
    }

    @Override
    public synchronized void write(byte[] byArray, int n2, int n3) {
        if (this.mBuffer.position() + n3 > this.mBuffer.capacity()) {
            this.expand(this.mBuffer.capacity() + n3);
        }
        this.mBuffer.put(byArray, n2, n3);
    }

    @Override
    public synchronized void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(String string) {
        this.write(string.getBytes("UTF-8"));
    }

    public synchronized void crlf() {
        this.write(13);
        this.write(10);
    }
}

