/*
 * Decompiled with CFR 0.152.
 */
package com.cloudplay.messagesdk.autobahn;

import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer mBuffer;

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.mBuffer = byteBuffer;
    }

    @Override
    public synchronized int read() {
        if (!this.mBuffer.hasRemaining()) {
            return -1;
        }
        return this.mBuffer.get() & 0xFF;
    }

    @Override
    public synchronized int read(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = Math.min(this.mBuffer.remaining(), n3);
        if (n4 == 0) {
            return -1;
        }
        this.mBuffer.get(byArray, n2, n4);
        return n4;
    }
}

